CREATE TABLE `yst_supp_item`  (
                                  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
                                  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
                                  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
                                  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
                                  `creator` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
                                  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
                                  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
                                  `updater` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
                                  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
                                  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
                                  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
                                  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
                                  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
                                  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
                                  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
                                  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
                                  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '品项ID',
                                  `supp_score` decimal(10, 8) NULL DEFAULT NULL COMMENT '供应商评分',
                                  `supp_code` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商SRM编码',
                                  `item_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '品项编号',
                                  `item_code2` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '短项目号',
                                  `item_code3` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目号',
                                  `item_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品项名称',
                                  `c3_id` bigint(20) NULL DEFAULT NULL,
                                  `item_cate_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品类编码',
                                  `more_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '超量比例',
                                  `less_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '欠量比例',
                                  `item_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '比例',
                                  `more_number` varchar(6) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可超量',
                                  `less_number` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可欠量',
                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '品项供货目录';

CREATE TABLE `yst_supp_c13`  (
                                 `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
                                 `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
                                 `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
                                 `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
                                 `creator` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
                                 `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
                                 `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
                                 `updater` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
                                 `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
                                 `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
                                 `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
                                 `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
                                 `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
                                 `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
                                 `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
                                 `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
                                 `c3_id` bigint(20) NULL DEFAULT NULL COMMENT '品项小类ID',
                                 `supp_code` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商SRM编码',
                                 `item_cate_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品类编码',
                                 `more_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '超量比例',
                                 `less_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '欠量比例',
                                 `item_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '比例',
                                 `less_number` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可欠量',
                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '品类供货目录';

CREATE TABLE `yst_item_proportion`  (
                                        `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
                                        `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
                                        `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
                                        `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
                                        `creator` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
                                        `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
                                        `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
                                        `updater` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
                                        `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
                                        `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
                                        `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
                                        `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
                                        `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
                                        `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
                                        `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
                                        `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
                                        `item_id` bigint(20) NULL DEFAULT NULL COMMENT '品项ID',
                                        `supp_score` decimal(10, 8) NULL DEFAULT NULL COMMENT '供应商评分',
                                        `supp_code` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商SRM编码',
                                        `item_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品项编号',
                                        `item_code2` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第二编号',
                                        `item_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品项名称',
                                        `c3_id` bigint(20) NULL DEFAULT NULL,
                                        `item_cate_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品类编码',
                                        `item_code3` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目号',
                                        `more_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '超量比例',
                                        `less_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '欠量比例',
                                        `item_proportion` decimal(20, 8) NULL DEFAULT NULL COMMENT '比例',
                                        `more_number` varchar(6) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可超量',
                                        `less_number` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可欠量',
                                        PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '比例表';